/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.bx.controller.api;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.dy.bx.param.BxPatrolQueryParam;
import cn.smarthse.dy.bx.param.BxPatrolStatusQueryParam;
import cn.smarthse.dy.bx.service.IBxPatrolService;
import cn.smarthse.dy.bx.vo.BxPatrolVo;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bx/api/patrol"})
@Validated
public class ApiBxPatrolDataController
extends ControllerSupport {
    private final IBxPatrolService bxPatrolService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @ApiOperationSupport(order=1)
    @PostMapping(value={"/listFinishedPatrol"})
    public ResponseData<JqGridData<BxPatrolVo>> listFinishedPatrol(@Validated @RequestBody BxPatrolQueryParam param) {
        if (param.getRows() > 1000) {
            return ResponseData.fail((String)"\u6bcf\u9875\u6700\u591a1000\u6761\u8bb0\u5f55");
        }
        if (param.getYear() == null) {
            param.setYear(Integer.valueOf(LocalDate.now().getYear()));
        }
        if (Objects.nonNull(param.getSearchAreaId())) {
            SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(param.getSearchAreaId());
            if (Objects.isNull(area)) {
                return ResponseData.fail((String)"\u8be5\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728");
            }
            param.setSearchAreaLevel(area.getLevel());
        }
        return ResponseData.success((Object)new JqGridData(this.bxPatrolService.listFinishedPatrol(param), new JqGridParam(param.getRows(), param.getPage())));
    }

    @ApiOperationSupport(order=2)
    @PostMapping(value={"/getCompanyPatrolStatusByYear"})
    public ResponseData<Boolean> getCompanyPatrolStatusByYear(@Validated @RequestBody BxPatrolStatusQueryParam param) {
        return ResponseData.success((Object)this.bxPatrolService.getCompanyPatrolStatusByYear(param));
    }

    @Generated
    public ApiBxPatrolDataController(IBxPatrolService bxPatrolService) {
        this.bxPatrolService = bxPatrolService;
    }
}

