/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.bx.controller.api;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.HtmlUtil;
import cn.smarthse.dy.bx.vo.ApiBxFileVo;
import cn.smarthse.dy.dy.bootstrap.properties.SysProperties;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.file.FileUtils;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bx/api/file"})
@Validated
public class ApiBxFileController
extends ControllerSupport {
    private final SysProperties sysProperties;
    private final OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvideService sysFileService;

    @CrossOrigin(origins={"*"})
    @PostMapping(value={"upload"})
    public ResponseData<ApiBxFileVo> upload(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) throws IOException {
        String hashCode = MD5.create().digestHex(fileData.getBytes());
        SysFileModel existSysFile = this.sysFileService.getFileByHash(hashCode);
        if (Objects.nonNull(existSysFile)) {
            ApiBxFileVo vo = new ApiBxFileVo();
            vo.setId(existSysFile.getId());
            return ResponseData.success((String)"\u6587\u4ef6\u4e0a\u4f20\u6210\u529f(hash\u503c\u5b58\u5728)\uff01", (Object)vo);
        }
        String type = FileTypeUtil.getType((InputStream)fileData.getInputStream(), (boolean)true);
        if (!this.sysProperties.getSupportFileTypes().contains(type)) {
            return ResponseData.fail((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
        }
        Object originalFilename = fileData.getOriginalFilename();
        String mainName = FileUtils.getPrefix((String)originalFilename);
        if (StrUtil.isBlank((CharSequence)(mainName = HtmlUtil.cleanHtmlTag((String)HtmlUtil.filter((String)mainName))))) {
            return ResponseData.fail((String)"\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5\uff01");
        }
        originalFilename = mainName + "." + FileUtils.getSuffix((String)originalFilename);
        String ossFileName = String.valueOf(UUID.randomUUID()) + "-" + (String)originalFilename;
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.supervise_05.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator;
        String realPath = this.ossClientBean.getLocal() + uploadDir + ossFileName;
        Object ossUrl = uploadDir + ossFileName;
        FileUtils.writeFromStream((MultipartFile)fileData, (String)realPath);
        if (this.ossClientBean.isAsynch()) {
            ossUrl = this.ossClientBean.OSSPutObject(ossFileName, new File(realPath), (String)ossUrl, (String)originalFilename);
            FileUtil.del((String)realPath);
        }
        SysFileModel file = new SysFileModel();
        file.setCid(null);
        file.setOssUrl((String)ossUrl);
        file.setResource(Integer.valueOf(FileResourceEnum.supervise_05.getValue()));
        file.setFileName((String)originalFilename);
        file.setFileSize(String.valueOf(fileData.getSize()));
        file.setFileExt(type);
        file.setFileHash(hashCode);
        file.setCreatorIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        file = this.sysFileService.addSysFile(file, null);
        ApiBxFileVo vo = new ApiBxFileVo();
        vo.setId(file.getId());
        return new ResponseData((Object)vo);
    }

    @Generated
    public ApiBxFileController(SysProperties sysProperties, OssClientBean ossClientBean) {
        this.sysProperties = sysProperties;
        this.ossClientBean = ossClientBean;
    }
}

