/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.bx.controller.api;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.dy.bx.param.BxCompanyNeedInspectionQueryParam;
import cn.smarthse.dy.bx.param.BxCompanyQueryParam;
import cn.smarthse.dy.bx.service.IBxCompanyService;
import cn.smarthse.dy.bx.vo.BxCompanyBxNeedInspectionVo;
import cn.smarthse.dy.bx.vo.BxCompanyVo;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bx/api/company"})
@Validated
public class ApiBxCompanyController
extends ControllerSupport {
    private final IBxCompanyService bxCompanyService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @PostMapping(value={"getData"})
    public ResponseData<JqGridData<BxCompanyVo>> getData(@Validated @RequestBody BxCompanyQueryParam param) {
        if (param.getRows() > 1000) {
            return ResponseData.fail((String)"\u6bcf\u9875\u6700\u591a1000\u6761\u8bb0\u5f55");
        }
        if (Objects.nonNull(param.getSearchAreaId())) {
            SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(param.getSearchAreaId());
            if (Objects.isNull(area)) {
                return ResponseData.fail((String)"\u8be5\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728");
            }
            param.setSearchAreaLevel(area.getLevel());
        }
        return ResponseData.success((Object)new JqGridData(this.bxCompanyService.getData(param), new JqGridParam(param.getRows(), param.getPage())));
    }

    @PostMapping(value={"getNeedInspectionData"})
    public ResponseData<JqGridData<BxCompanyBxNeedInspectionVo>> getNeedInspectionCompany(@Validated @RequestBody BxCompanyNeedInspectionQueryParam param) {
        if (param.getRows() > 1000) {
            return ResponseData.fail((String)"\u6bcf\u9875\u6700\u591a1000\u6761\u8bb0\u5f55");
        }
        return ResponseData.success((Object)new JqGridData(this.bxCompanyService.getNeedInspectionCompany(param), new JqGridParam(param.getRows(), param.getPage())));
    }

    @Generated
    public ApiBxCompanyController(IBxCompanyService bxCompanyService) {
        this.bxCompanyService = bxCompanyService;
    }
}

