package cn.smarthse.dy.dy.vo.workerTraining;

import cn.smarthse.framework.core.utils.NumberUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

@Data
public class WorkerTrainingStatisticsOneVo implements Serializable {

    private Long areaId;
    private String areaName;

    /**
     * 单位总数
     */
    private Integer companyCount = 0;

    /**
     * 参与培训单位总数
     */
    private Integer attendTrainingCompanyCount = 0;

    /**
     * 单位培训完成率
     */
    private String companyTrainingCompletionRate;

    /**
     * 参与培训人数（个）
     */
    private Integer attendTrainingStaffCount = 0;

    /**
     * 参与培训单位（次）
     */
    private Integer attendTrainingCompanyCount2 = 0;

    /**
     * 参与培训人次（次）
     */
    private Integer attendTrainingStaffCount2 = 0;

    public String getCompanyTrainingCompletionRate() {
        if (Objects.isNull(companyTrainingCompletionRate)) {
            return NumberUtils.customDivReturnString(attendTrainingCompanyCount, companyCount);
        } else {
            return companyTrainingCompletionRate;
        }
    }

}
