package cn.smarthse.dy.dy.vo.workerTraining;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;

@Data
public class WorkerTrainingStaffOneVo implements Serializable {

    /**
     * 人员姓名
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    /**
     * 身份证
     */
    @Desensitization(type = DesensitizationType.ID_CARD)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;

    /**
     * 手机号
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String tel;

    /**
     * 性别(1 : 男 ， 0 : 女)
     */
    private Integer gender;
    private Integer age;

}
