package cn.smarthse.dy.dy.vo.workerTraining;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

@Data
public class WorkerTrainingProjOneVo implements Serializable {

    /**
     * ID
     */
    private Long id;

    private Long cid;
    private String companyName;
    private String creditCode;

    /**
     * 培训项目名称
     */
    private String trainProjName;

    /**
     * 培训发布单位ID
     */
    private Long trainPublishUnitId;

    /**
     * 培训发布单位
     */
    private String trainPublishUnit;

    /**
     * 报名人数
     */
    private Integer signInNums = 0;

    /**
     * 签到二维码
     */
    private String signInQrCode;

    /**
     * 培训开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate trainBeginDate;

    /**
     * 培训结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate trainEndDate;

    /**
     * 培训内容
     */
    private String trainContent;

}
