package cn.smarthse.dy.dy.vo.workerTraining;

import cn.smarthse.modules.health.enums.train.TrainProfileStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

@Data
public class WorkerTrainingProjListVo implements Serializable {

    /**
     * ID
     */
    private Long id;

    private Long cid;
    private String companyName;
    private String creditCode;

    /**
     * 培训项目名称
     */
    private String trainProjName;

    /**
     * 培训发布单位ID
     */
    private Long trainPublishUnitId;

    /**
     * 培训发布单位
     */
    private String trainPublishUnit;

    /**
     * 报名人数
     */
    private Integer signInNums = 0;

    /**
     * 签到二维码
     */
    private String signInQrCode;

    /**
     * 培训档案状态，TrainProfileStatusEnum
     */
    private Byte trainProfileStatus;
    private String trainProfileStatusStr;

    /**
     * 培训开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate trainBeginDate;

    /**
     * 培训结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate trainEndDate;

    /**
     * 培训内容
     */
    private String trainContent;

    public String getTrainProfileStatusStr() {

        return Objects.isNull(trainProfileStatus) ? "-" : TrainProfileStatusEnum.getNameByValue(trainProfileStatus);
    }

}
