package cn.smarthse.dy.dy.vo.offlineTraining;

import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@Data
public class OfflineTrainingProjOneVo implements Serializable {

    /**
     * 培训项目名称
     */
    private String trainProjName;

    /**
     * 培训开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date trainBeginDate;

    /**
     * 培训结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date trainEndDate;

    /**
     * 培训人员类型（英文逗号分割），CertificateStaffNameTypeEnum
     */
    private String trainPersonnelType;
    private String trainPersonnelTypeStr;
    private Map<Long, String> trainPersonnelTypeMap;

    /**
     * 培训区域id
     */
    private Long trainAreaId;
    private String trainAreaName;

    /**
     * 培训内容
     */
    private String trainContent;

    /**
     * 培训发布单位
     */
    private String trainPublishUnit;

    /**
     * 签到二维码
     */
    private String signInQrCode;

    /**
     * 签退二维码
     */
    private String signOutQrCode;


    public String getTrainPersonnelTypeStr() {

        return Objects.isNull(trainPersonnelType) ? "-" : CertificateStaffNameTypeEnum.getNameTypesByIds(trainPersonnelType);
    }

}
