package cn.smarthse.dy.dy.vo.offlineTraining;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class OfflineTrainingCompanyListVo implements Serializable {

    /**
     * ID
     */
    private Long id;
    /**
     * 企业名称
     */
    private String name;
    /**
     * 信用代码
     */
    private String unifiedSocialCc;
    private Long provinceId;
    private Long cityId;
    private Long districtId;
    private Long streetId;
    /**
     * 行政区划
     */
    private Long detailAreaId;
    /**
     * 区域名称（全）
     */
    private String detailAreaName;
    /**
     * 所属行业
     */
    private Long industryCategory;
    /**
     * 行业分类code
     */
    private String industryCategoryCode;
    /**
     * corp_type 行业分类名称（sys_param.param_code）
     */
    private String industryCategoryName;
    /**
     * 是否存在培训证书
     */
    private Boolean isHasCertificate;
    /**
     * 是否进入在线培训企业库
     */
    private Boolean isStore;
    /**
     * 序号企业名称信用代码行政区划新增人员姓名
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String staffName;
    /**
     * 联系电话
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String staffTel;
    /**
     * 添加时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime createDate;

}
