package cn.smarthse.dy.dy.vo.offlineTraining;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@Data
public class OfflineTrainingCertificateVo implements Serializable {

    /**
     * ID
     */
    private Long id;

    /**
     * 人员姓名
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    /**
     * 身份证
     */
    @Desensitization(type = DesensitizationType.ID_CARD)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;

    /**
     * 人员类型，CertificateStaffNameTypeEnum
     */
    private Long trainPersonnelType;
    private String trainPersonnelTypeStr;

    /**
     * 签退时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date signOutTime;

    /**
     * 培训发布单位
     */
    private String trainPublishUnit;

    /**
     * 证书编号
     */
    private String certificateNo;

    private Long cid;

    private Boolean isHasCertificate;

    private Boolean isStore;

    public String getTrainPersonnelTypeStr() {

        return Objects.isNull(trainPersonnelType) ? "-" : CertificateStaffNameTypeEnum.getNameTypeById(trainPersonnelType);
    }

}
