package cn.smarthse.dy.dy.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Accessors(chain = true)
@Data
public class PersonnelListVo implements Serializable {

    private Long id;

    /**
     * 单位名称
     */
    private String organizationName;

    /**
     * 用户姓名
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String fullName;

    /**
     * 联系电话
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String tel;

    /**
     * 角色 17-属地乡镇辅助监督员 18-医共体医务人员
     */
    private String roleStr;

    /**
     * 浙政钉accoundId
     */
    private Long accountId;

    /**
     * 数据来源ID
     */
    private String dataSourceId;

    private Boolean isValid;

}
