package cn.smarthse.dy.dy.provider;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.dy.dy.dto.offlineTraining.*;
import cn.smarthse.dy.dy.entity.OfflineTrainingProj;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingQrListVo;

public interface IOfflineTrainingQrProviderService {

    /**
     * 选择企业情况
     *
     * @param param
     * @return {@link JqGridData<OfflineTrainingQrListVo>}
     * @author ShenZQ
     * @since 2024/6/26 下午1:23
     */
    JqGridData<OfflineTrainingQrListVo> getOfflineTrainingQrList(OfflineTrainingQrListParam param);

    OfflineTrainingProj getOfflineTrainingProjById(Long id);

    /**
     * 线下培训签到新增
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2024/6/26 下午1:24
     */
    Boolean saveOfflineTrainingQr(OfflineTrainingQrAddParam param);

    /**
     * 线下培训签到修改
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2024/6/26 上午10:54
     */
    Boolean updateOfflineTrainingQr(OfflineTrainingQrEditParam param);

    /**
     * 线下培训签到
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2024/6/26 下午1:25
     */
    Boolean signIn(OfflineTrainingQrSignInParam param);

    /**
     * 线下培训签退
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2024/6/26 下午1:25
     */
    Boolean signOut(OfflineTrainingQrSignOutParam param);

    /**
     * 线下培训证书重新生成
     *
     * @param id
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2024/6/26 下午1:25
     */
    Boolean regeneration(Long id);

    /**
     * 线下培训签退重新执行子任务
     *
     * @param id
     * @author ShenZQ
     * @since 2024/7/3 下午3:03
     */
    void reSignOutSubTask(Long id);

}
