package cn.smarthse.dy.dy.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 短信类型
 */
@AllArgsConstructor
@Getter
public enum DySmsTemplateTypeEnum {


    THREE_SIMULTANEITY("新改扩建项目“三同时”工作未完成", 1),
    WARNING_SIGNS("职业危害岗位未设置警示标识", 2),
    ARCHIVES("职业卫生档案未建立", 3),
    TRAIN("危害岗位人员未培训", 4),
    REPORT("职业病危害项目未申报", 5),
    PROTECTIVE_EQUIPMENT("防护用品未使用或未记录发放记录", 6),
    PHYSICAL_EXAMINATION("危害岗位人员未体检", 7),
    CHECK("职业病危害因素未检测", 8),

    /**
     * 告知企业截止某天，风险都已经化解，请继续保持？
     */
    NONE("告知企业截止某天，风险都已经化解，请继续保持？", 11),

    /**
     * 提示企业及时去“浙里卫企”化解风险？
     */
    GO_TO_HSE("提示企业及时去“浙里卫企”化解风险？", 12),
    ;

    private String name;
    private Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (DySmsTemplateTypeEnum c : DySmsTemplateTypeEnum.values()) {
            if (Objects.equals(c.getValue(), value)) {
                return c.name;
            }
        }
        return null;
    }

    public static Integer getValue(String name) {
        if (name == null) {
            return null;
        }
        for (DySmsTemplateTypeEnum c : DySmsTemplateTypeEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return null;
    }
}
