package cn.smarthse.dy.dy.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @TableName worker_training_proj
 */
@TableName(value = "worker_training_proj")
@Data
public class WorkerTrainingProj implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 培训项目名称
     */
    @TableField(value = "train_proj_name")
    private String trainProjName;

    /**
     * 培训发布单位ID
     */
    @TableField(value = "train_publish_unit_id")
    private Long trainPublishUnitId;

    /**
     * 培训发布单位
     */
    @TableField(value = "train_publish_unit")
    private String trainPublishUnit;

    /**
     * 培训开始时间
     */
    @TableField(value = "train_begin_date")
    private LocalDate trainBeginDate;

    /**
     * 培训结束时间
     */
    @TableField(value = "train_end_date")
    private LocalDate trainEndDate;

    /**
     *
     */
    @TableField(value = "cid")
    private Long cid;

    /**
     * 培训内容
     */
    @TableField(value = "train_content")
    private String trainContent;

    /**
     * 培训档案状态，TrainProfileStatusEnum
     */
    @TableField(value = "train_profile_status")
    private Byte trainProfileStatus;

    /**
     * 提交者区域id
     */
    @TableField(value = "sub_area_id")
    private Long subAreaId;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 创建人ID
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private LocalDateTime createDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private LocalDateTime updateDate;
}