package cn.smarthse.dy.dy.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 东阳短信模板
 *
 * @TableName dy_sms_template
 */
@TableName(value = "dy_sms_template")
@Data
public class DySmsTemplate implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 类型DySmsTemplateTypeEnum
     */
    @TableField(value = "type")
    private Integer type;

    /**
     * 内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 创建人ID
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}