package cn.smarthse.dy.dy.entity;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 东阳服务指导记录
 *
 * @TableName dy_service_guidance_records
 */
@TableName(value = "dy_service_guidance_records")
@Data
public class DyServiceGuidanceRecords implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 同一批次编号
     */
    private Long no;

    /**
     * 企业ID
     */
    @TableField(value = "cid")
    private Long cid;

    /**
     * 企业名称
     */
    @TableField(value = "company_name")
    private String companyName;

    /**
     * 统一社会信用代码
     */
    @TableField(value = "credit_code")
    private String creditCode;

    /**
     * 区域id
     */
    @TableField(value = "detail_area_id")
    private Long detailAreaId;

    /**
     * 省id
     */
    @TableField(value = "province_id")
    private Long provinceId;

    /**
     *
     */
    @TableField(value = "province_name")
    private String provinceName;

    /**
     * 市id
     */
    @TableField(value = "city_id")
    private Long cityId;

    /**
     *
     */
    @TableField(value = "city_name")
    private String cityName;

    /**
     * 区县id
     */
    @TableField(value = "area_id")
    private Long areaId;

    /**
     *
     */
    @TableField(value = "area_name")
    private String areaName;

    /**
     * 街道id
     */
    @TableField(value = "street_id")
    private Long streetId;

    /**
     *
     */
    @TableField(value = "street_name")
    private String streetName;

    /**
     * 接收手机号
     */
    @TableField(value = "receiver_tel")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String receiverTel;

    /**
     * 发送者ID
     */
    @TableField(value = "sender_id")
    private Long senderId;

    /**
     * 发送者名称
     */
    @TableField(value = "sender_name")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String senderName;

    /**
     * 发送年份
     */
    @TableField(value = "send_year")
    private Integer sendYear;

    /**
     * 发送时间
     */
    @TableField(value = "send_time")
    private Date sendTime;

    /**
     * dy_sms_template.id
     */
    @TableField(value = "sms_template_id")
    private Long smsTemplateId;

    /**
     * 发送内容
     */
    @TableField(value = "send_content")
    private String sendContent;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 创建人ID
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}