package cn.smarthse.dy.dy.entity;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 东阳对接人员
 *
 * @TableName dy_organization_user
 */
@TableName(value = "dy_organization_user")
@Data
public class DyOrganizationUser implements Serializable {

    @TableId(value = "id")
    private Long id;

    /**
     * 区域id
     */
    @TableField(value = "area_id")
    private Long areaId;

    /**
     * 单位名称
     */
    @TableField(value = "organization_name")
    private String organizationName;

    /**
     * 用户姓名
     */
    @TableField(value = "full_name")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String fullName;

    /**
     * 手机号
     */
    @TableField(value = "tel")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String tel;

    /**
     * 角色(多选，","隔开，尽量不用这个字段)17-属地乡镇辅助监督员 18-医共体医务人员
     */
    @TableField(value = "role")
    private String role;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    /**
     * 浙政钉accoundId
     */
    @TableField(value = "account_id")
    private Long accountId;

    /**
     * 数据来源ID（原ID）
     */
    @TableField(value = "data_source_id")
    private String dataSourceId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}