package cn.smarthse.dy.dy.entity;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@TableName(value = "dy_company")
@Data
public class DyCompany implements Serializable {

    @TableId(value = "id")
    private Long id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "unified_social_cc")
    private String unifiedSocialCc;

    @TableField(value = "detail_area_id")
    private Long detailAreaId;

    @TableField(value = "industry_category")
    private Long industryCategory;

    @TableField(value = "is_has_certificate")
    private Boolean isHasCertificate;

    @TableField(value = "is_store")
    private Boolean isStore;

    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @TableField(value = "staff_name")
    private String staffName;

    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @TableField(value = "staff_tel")
    private String staffTel;

    @TableField(value = "is_valid")
    private Boolean isValid;

    @TableField(value = "create_by")
    private Long createBy;

    @TableField(value = "create_date")
    private LocalDateTime createDate;

    @TableField(value = "update_by")
    private Long updateBy;

    @TableField(value = "update_date")
    private LocalDateTime updateDate;

}