package cn.smarthse.dy.dy.dto.workerTraining;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;

@Data
public class WorkerTrainingQrSignInParam implements Serializable {

    /**
     * 培训项目ID
     */
    @NotNull(message = "培训项目ID不能为空")
    private Long trainProjId;

    /**
     * 人员姓名
     */
    @NotBlank(message = "人员姓名不能为空")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    /**
     * 身份证
     */
    @NotBlank(message = "身份证不能为空")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String tel;

}
