package cn.smarthse.dy.dy.dto.workerTraining;

import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

@Data
public class WorkerTrainingProjEditParam implements Serializable {

    private Long loginUserId;

    @NotNull(message = "培训项目ID不能为空")
    private Long id;

    /**
     * 培训档案状态，TrainProfileStatusEnum
     */
    @NotNull(message = "培训档案状态不能为空")
    private Byte trainProfileStatus;

    /**
     * 培训项目名称
     */
    private String trainProjName;

    /**
     * 培训发布单位ID
     */
    private Long trainPublishUnitId;
    private String trainPublishUnit;

    /**
     * 培训开始时间
     */
    private LocalDate trainBeginDate;

    /**
     * 培训结束时间
     */
    private LocalDate trainEndDate;

    private Long cid;

    /**
     * 培训内容
     */
    private String trainContent;

}
