package cn.smarthse.dy.dy.dto.workerTraining;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
public class WorkerTrainingChooseCompanyListParam extends JqGridParam {

    private Long userAreaId;
    private Byte userAreaLevel;

    /**
     * 选中的区域id
     */
    private Long searchAreaId;
    private Byte searchAreaLevel;

    /**
     * 所属行业
     */
    private List<Long> industryCategoryList;
    /**
     * 重点行业
     */
    private List<Long> importantIndustryCategoryList;
    /**
     * 合规重点行业
     */
    private List<Long> complianceImportantIndustryCategoryList;

    /**
     * 职业病危害风险等级 0未评估 1Ⅰ级 2Ⅱ级 3Ⅲ级
     */
    private Long riskLevel;

    /**
     * 职业卫生分类 1甲类 2 乙类   3丙类
     */
    private Byte grade;
    /**
     * 分类依据：0无来源， 1接害三人以下企业 2 分类自查 3 根据行业划分  4 依据容错自纠调整  5未及时化解风险企业  6信用监管提档企业
     */
    private String gradeSource;

}
