package cn.smarthse.dy.dy.dto.offlineTraining;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class OfflineTrainingQrListParam extends JqGridParam {

    /**
     * 培训项目ID
     */
    @NotNull(message = "培训项目ID不能为空")
    private Long trainProjId;

    /**
     * 人员姓名
     */
    @NotBlank(message = "人员姓名不能为空")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    /**
     * 身份证
     */
    @NotBlank(message = "身份证不能为空")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;

}
