package cn.smarthse.dy.dy.dto.api;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class PersonnelDto implements Serializable {

    /**
     * 区域id
     */
    @NotNull(message = "区域id不能为空")
    private Long areaId;

    /**
     * 用户所在单位
     */
    @NotBlank(message = "用户所在单位不能为空")
    private String organizationName;

    /**
     * 用户姓名
     */
    @NotBlank(message = "用户姓名不能为空")
    private String fullName;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String tel;

    /**
     * 角色 17-属地乡镇辅助监督员 18-医共体医务人员
     */
    @NotEmpty(message = "角色不能为空")
    private List<Long> roleList;

    /**
     * 浙政钉accoundId
     */
    @NotNull(message = "浙政钉accoundId不能为空")
    private Long accountId;

    /**
     * 数据来源ID
     */
    @NotBlank(message = "数据来源ID不能为空")
    private String dataSourceId;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @NotNull(message = "是否有效不能为空")
    private Boolean isValid;

}