package cn.smarthse.dy.dy.dto.api;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;

@Data
public class CompanyAddDto implements Serializable {

    /**
     * 数据来源ID（原ID）
     */
    @NotBlank(message = "数据来源ID不能为空")
    private String dataSourceId;

    /**
     * 企业名称
     */
    @NotBlank(message = "企业名称不能为空")
    private String name;

    /**
     * 统一社会信用代码
     */
    @NotBlank(message = "统一社会信用代码不能为空")
    private String unifiedSocialCc;

    /**
     * 区域id
     */
    @NotNull(message = "区域id不能为空")
    private Long detailAreaId;

    /**
     * 营业状态（1-正常 0-关闭）
     */
    @NotNull(message = "营业状态不能为空")
    private Byte businessState;

    /**
     * 行业分类id
     */
    //@NotNull(message = "行业分类id不能为空")
    private Long industryCategory;

    /**
     * 法人代表姓名
     */
    private String legalName;

    /**
     * 法人代表联系电话
     */
    private String legalTel;

    /**
     * 职业卫生管理联系人
     */
    @NotBlank(message = "职业卫生管理联系人不能为空")
    private String occManagerName;

    /**
     * 职业卫生管理联系人电话
     */
    @NotBlank(message = "职业卫生管理联系人电话不能为空")
    private String occManagerTel;

    /**
     * 企业主要负责人
     */
    private String mainLeaderName;

    /**
     * 企业主要负责人手机号码
     */
    private String mainLeaderTel;

}