package cn.smarthse.dy.bx.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class BxCompanyVo implements Serializable {

    /**
     * 企业id
     */
    private Long id;

    /**
     * 单位名称
     */
    private String name;

    /**
     * 营业状态（1-正常 0-关闭）
     */
    private Byte businessState;

    /**
     * 统一信用代码
     */
    private String unifiedSocialCc;

    /**
     * 行政区划id
     */
    private Long areaId;

    /**
     * 详细地址
     */
    private String workAddress;

    /**
     * 法人代表姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String legalName;

    /**
     * 法人代表联系电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String legalTel;

    /**
     * 企业主要负责人
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String mainLeaderName;

    /**
     * 负责人手机号码
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String mainLeaderTel;

    /**
     * 职业卫生管理联系人
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String occManagerName;

    /**
     * 职业卫生管理联系人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String occManagerTel;

    /**
     * 申报年份
     */
    private String declareYear;

    /**
     * 监督单位名称
     */
    private String supervisionUnitName;

    /**
     * 企业规模（1-大型企业，2-中型企业，3-小型企业，4-微型企业，5-未划分）
     */
    private String scale;

    /**
     * 行业分类id
     */
    private Long industryCategory;

    /**
     * 接害人数
     */
    private String harmStaffCount;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 更新时间
     */
    private Date updateDate;

    /**
     * 是否删除
     */
    private Boolean isDel;

    /**
     * 职业卫生分类 1甲类 2 乙类 3丙类 0未分类
     */
    private Integer grade;
    /**
     * 分类依据 0未分类 1接害三人以下企业 2分类自查 3根据行业划分 4依据容错自纠调整 5风险未及时化解 6安装在线监测监控企业 7合规提档企业 8监管认定 9依据劳务派遣单位
     */
    private Integer gradeSource;

}
