package cn.smarthse.dy.bx.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class BxCompanyRiskStatusVo implements Serializable {

    /**
     *企业id
     */
    private Long cid;

    /**
     *企业名称
     */
    private String name;

    /**
     *企业信用代码
     */
    private String unifiedSocialCc;

    /**
     *推送时间
     */
    private Date findTime;


    /**
     * 申报有无风险", notes = "1有风险0无风险"
     */
    private Boolean declareRisk;
    /**
     * 申报风险推送时间", notes = "NULL说明从未推送过风险"
     */
    private Date declareRiskPushTime;

    /**
     * 体检有无风险", notes = "1有风险0无风险"
     */
    private Boolean physicalExaminationRisk;
    /**
     * 体检风险推送时间", notes = "NULL说明从未推送过风险"
     */
    private Date physicalExaminationRiskPushTime;

    /**
     * 检测有无风险", notes = "1有风险0无风险"
     */
    private Boolean checkRisk;
    /**
     * 检测风险推送时间", notes = "NULL说明从未推送过风险"
     */
    private Date checkRiskPushTime;

    /**
     * 培训有无风险", notes = "1有风险0无风险"
     */
    private Boolean trainingRisk;
    /**
     * 培训风险推送时间", notes = "NULL说明从未推送过风险"
     */
    private Date trainingRiskPushTime;

    /**
     * 三同时有无风险", notes = "1有风险0无风险"
     */
    private Boolean threeSimultaneousRisk;
    /**
     * 三同时风险推送时间", notes = "NULL说明从未推送过风险"
     */
    private Date threeSimultaneousRiskPushTime;

    /**
     * 个人防护用品有无风险", notes = "1有风险0无风险"
     */
    private Boolean protectEquipRisk;
    /**
     * 个人防护用品风险推送时间", notes = "NULL说明从未推送过风险"
     */
    private Date protectEquipRiskPushTime;

    /**
     * 现场示警标识有无风险", notes = "1有风险0无风险"
     */
    private Boolean warnSignManageRisk;
    /**
     * 现场示警标识风险推送时间", notes = "NULL说明从未推送过风险"
     */
    private Date warnSignManageRiskPushTime;

    /**
     * 职业卫生档案有无风险", notes = "1有风险0无风险"
     */
    private Boolean healthManageFilesRisk;
    /**
     * 职业卫生档案风险推送时间", notes = "NULL说明从未推送过风险"
     */
    private Date healthManageFilesRiskPushTime;

}
