package cn.smarthse.dy.bx.param;

import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class BxPatrolQueryParam implements Serializable {

    /**
     * 页码
     */
    @NotNull(message = "页码不能为空")
    private int page = 1;

    /**
     * 每页几条记录
     */
    @NotNull(message = "每页几条记录不能为空")
    private int rows = 1000;

    /**
     * 开始时间, example = "2025-01-01"
     */
    @NotNull(message = "开始时间不能为空")
    private Date beginTime;

    /**
     * 结束时间, example = "2025-12-10"
     */
    @NotNull(message = "结束时间不能为空")
    private Date endTime;

    /**
     * 行政区划id
     */
    private Long searchAreaId;

    /**
     * hidden = true
     */
    private Byte searchAreaLevel;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 年份
     */
    @NotNull(message = "年份不能为空")
    private Integer year;
}
