package cn.smarthse.dy.bx.param;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class BxCompanyRiskStatusQueryParam implements Serializable {

    /**
     * 页码
     */
    @NotNull(message = "页码不能为空")
    private int page = 1;

    /**
     * 每页几条记录
     */
    @NotNull(message = "每页几条记录不能为空")
    private int rows = 1000;

    /**
     * 企业id
     */
    @NotEmpty(message = "企业id不能为空")
    private List<Long> cidList;

    /**
     * 是否存在风险
     */
    private Boolean haveRisk;

}
