package cn.smarthse.dy.bx.param;

import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class BxCompanyQueryParam implements Serializable {

    /**
     * 页码
     */
    @NotNull(message = "页码不能为空")
    private int page = 1;

    /**
     * 每页几条记录
     */
    @NotNull(message = "每页几条记录不能为空")
    private int rows = 1000;

    /**
     * 开始时间, example = "2025-01-01"
     */
    private Date beginTime;

    /**
     * 结束时间, example = "2025-12-10"
     */
    private Date endTime;

    /**
     * 行政区划id
     */
    private Long searchAreaId;

    /**
     * hidden = true
     */
    private Byte searchAreaLevel;

    /**
     * hidden = true
     */
    private String name;

}
