package cn.smarthse.dy.bx.param;

import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class BxCompanyNeedInspectionQueryParam implements Serializable {

    /**
     * 页码
     */
    @NotNull(message = "页码不能为空")
    private int page = 1;

    /**
     * 每页几条记录
     */
    @NotNull(message = "每页几条记录不能为空")
    private int rows = 1000;

    /**
     * 需巡查企业类型 1-丙类企业 2-未及时化解风险企业(超过4个月、接害人数≥3人) 3-丙类且未及时化解风险企业(接害人数≥3人)
     */
    private Byte inspectionType;

    /**
     * 企业id
     */
    private List<Long> cidList;
}
