package cn.smarthse.dy.bx.param;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;

@Data
public class BxCompanyChangePushParam implements Serializable {

    /**
     * 是否是历史数据
     */
    @NotNull(message = "是否是历史数据不能为空")
    private Boolean historicalData;

    /**
     * 数据来源ID
     */
    @NotBlank(message = "数据来源ID不能为空")
    private String sourceId;

    /**
     * 企业ID
     */
    @NotNull(message = "企业ID不能为空")
    private Long cid;

    /**
     * 联系人
     */
    @NotBlank(message = "联系人不能为空")
    private String contactName;

    /**
     * 联系电话
     */
    @NotBlank(message = "联系电话不能为空")
    private String contactTel;

    /**
     * 变更类型
     * 2-拟关停
     * 31-拟跨地市迁移（含跨省）
     * 32-拟地市内迁移
     * 33-拟辖区内迁移
     * 4-拟恢复
     */
    @NotNull(message = "变更类型不能为空")
    private Integer stopType;

    /**
     * 原因类型
     * 1-非生产型或不存在危害因素的企业
     * 2-重复企业
     * 3-实际已关停，但营业执照未注销
     * 4-已注销企业
     */
    private Integer reasonType;

    /**
     * 佐证材料文件ID，多个的话用英文逗号隔开，最多三张
     */
    private String fileIds;

    /**
     * 迁移到哪的区域id，迁移出省的话，就传0好了
     */
    private Long stopAreaId;

    /**
     * 原因类型为2时有效，
     * 重复企业的cid，多个的话用英文逗号隔开
     */
    private String repeatCid;

}