/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.wcsp.utils;

import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMService;
import cn.com.westone.wcspsdk.baseservice.km.KeyNoUpdateStrategySpec;
import cn.com.westone.wcspsdk.baseservice.km.KeyUpdateStrategySpec;
import cn.com.westone.wcspsdk.typicalservice.LightDataService;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.smarthse.core.wcsp.context.WcspContext;
import cn.smarthse.core.wcsp.pool.WcspServicePlatformPool;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WcspEncryptionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspEncryptionUtils.class);
    private static WcspServicePlatformPool wcspServicePlatformPool;
    private static WcspContext wcspContext;
    private static volatile String keyId;
    private static final ThreadLocal<LightDataService> lightDataServiceThreadLocal;

    public static void initialize(WcspServicePlatformPool pool) {
        wcspServicePlatformPool = pool;
        wcspContext = pool.getWcspContext();
        log.info("WcspEncryptionUtils\u8d44\u6e90\u5df2\u521d\u59cb\u5316");
    }

    public static void close() {
        if (wcspServicePlatformPool != null) {
            wcspServicePlatformPool.close();
        }
        log.info("WcspEncryptionUtils\u8d44\u6e90\u5df2\u91ca\u653e");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getKeyId(String alias, String description) {
        if (Objects.nonNull(keyId)) {
            return keyId;
        }
        Class<WcspEncryptionUtils> clazz = WcspEncryptionUtils.class;
        synchronized (WcspEncryptionUtils.class) {
            if (Objects.nonNull(keyId)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return keyId;
            }
            CryptoServicePlatform platform = null;
            boolean isHealthy = true;
            try {
                String string;
                block17: {
                    platform = wcspServicePlatformPool.borrowObject();
                    KMService service = KMService.getInstance((CryptoServicePlatform)platform);
                    service.init(new Object[0]);
                    KMSecretKey secretKey = service.createSecretKey("SM4", "ENC", alias, description, (KeyUpdateStrategySpec)new KeyNoUpdateStrategySpec.Builder().build());
                    try {
                        keyId = secretKey.keyId();
                        log.info("\u6210\u529f\u521b\u5efaSM4\u52a0\u5bc6\u5bc6\u94a5\uff0cKeyId: {}", (Object)keyId);
                        string = keyId;
                        if (secretKey == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (secretKey != null) {
                                try {
                                    secretKey.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            isHealthy = false;
                            log.error("\u521b\u5efa\u52a0\u5bc6\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
                            throw new RuntimeException("Failed to create encryption key", e);
                        }
                    }
                    secretKey.close();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return string;
            }
            finally {
                if (Objects.nonNull(platform)) {
                    wcspServicePlatformPool.returnObject(platform, isHealthy);
                }
            }
        }
    }

    private static LightDataService getLightDataService(WcspServicePlatformPool pool, String keyId) throws Exception {
        LightDataService service = lightDataServiceThreadLocal.get();
        if (Objects.isNull(service)) {
            CryptoServicePlatform platform = pool.borrowObject();
            service = LightDataService.getInstance((CryptoServicePlatform)platform, (String)keyId);
            lightDataServiceThreadLocal.set(service);
        }
        return service;
    }

    public static String executeEncryptionByWcspLightDataServiceCommon(String data, String alias, String description, Function<byte[], String> resultEncoder) {
        String string;
        LightDataService service = null;
        boolean isHealthy = true;
        try {
            service = WcspEncryptionUtils.getLightDataService(wcspServicePlatformPool, WcspEncryptionUtils.getKeyId(alias, description));
            byte[] encrypted = service.encrypt(ConversionUtils.Data.fromUTF8String((String)data));
            string = resultEncoder.apply(encrypted);
        }
        catch (Exception e) {
            try {
                isHealthy = false;
                log.error("\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("executeEncryptionByWcspLightDataServiceCommon", e);
            }
            catch (Throwable throwable) {
                WcspEncryptionUtils.cleanupService(service, isHealthy);
                throw throwable;
            }
        }
        WcspEncryptionUtils.cleanupService(service, isHealthy);
        return string;
    }

    public static String executeDecryptionByWcspLightDataServiceCommon(String data, String alias, String description, Function<String, byte[]> encryptEncoder, Function<byte[], String> resultEncoder) {
        String string;
        LightDataService service = null;
        boolean isHealthy = true;
        try {
            service = WcspEncryptionUtils.getLightDataService(wcspServicePlatformPool, WcspEncryptionUtils.getKeyId(alias, description));
            byte[] decrypted = service.decrypt(encryptEncoder.apply(data));
            string = resultEncoder.apply(decrypted);
        }
        catch (Exception e) {
            try {
                isHealthy = false;
                log.error("\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("executeDecryptionByWcspLightDataServiceCommon", e);
            }
            catch (Throwable throwable) {
                WcspEncryptionUtils.cleanupService(service, isHealthy);
                throw throwable;
            }
        }
        WcspEncryptionUtils.cleanupService(service, isHealthy);
        return string;
    }

    private static void cleanupService(LightDataService service, boolean isHealthy) {
        if (Objects.nonNull(service)) {
            lightDataServiceThreadLocal.remove();
            wcspServicePlatformPool.returnObject(service.platform(), isHealthy);
        }
    }

    public static String encryptByWcspLightDataService(String data, String alias, String description) {
        return WcspEncryptionUtils.executeEncryptionByWcspLightDataServiceCommon(data, alias, description, ConversionUtils.Data::toBase64String);
    }

    public static String encryptByWcspLightDataService(String data) {
        return WcspEncryptionUtils.encryptByWcspLightDataService(data, wcspContext.getWcspAlias(), wcspContext.getWcspDescription());
    }

    public static String encryptByWcspLightDataServiceHex(String data, String alias, String description) {
        return WcspEncryptionUtils.executeEncryptionByWcspLightDataServiceCommon(data, alias, description, ConversionUtils.Data::toHexString);
    }

    public static String encryptByWcspLightDataServiceHex(String data) {
        return WcspEncryptionUtils.encryptByWcspLightDataServiceHex(data, wcspContext.getWcspAlias(), wcspContext.getWcspDescription());
    }

    public static String decryptByWcspLightDataService(String data, String alias, String description) {
        return WcspEncryptionUtils.executeDecryptionByWcspLightDataServiceCommon(data, alias, description, ConversionUtils.Data::fromBase64String, ConversionUtils.Data::toUTF8String);
    }

    public static String decryptByWcspLightDataService(String data) {
        return WcspEncryptionUtils.decryptByWcspLightDataService(data, wcspContext.getWcspAlias(), wcspContext.getWcspDescription());
    }

    public static String decryptByWcspLightDataServiceHex(String data, String alias, String description) {
        return WcspEncryptionUtils.executeDecryptionByWcspLightDataServiceCommon(data, alias, description, ConversionUtils.Data::fromHexString, ConversionUtils.Data::toUTF8String);
    }

    public static String decryptByWcspLightDataServiceHex(String data) {
        return WcspEncryptionUtils.decryptByWcspLightDataServiceHex(data, wcspContext.getWcspAlias(), wcspContext.getWcspDescription());
    }

    @Generated
    private WcspEncryptionUtils() {
    }

    static {
        lightDataServiceThreadLocal = new ThreadLocal();
    }
}

