/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.encrypt.pool;

import cn.com.westone.wcspsdk.AuthParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.smarthse.core.encrypt.context.WcspEncryptContext;
import java.time.Duration;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WcspCryptoServicePlatformPool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspCryptoServicePlatformPool.class);
    private final WcspEncryptContext context;
    private final GenericObjectPool<CryptoServicePlatform> pool;
    private final AtomicInteger borrowCount = new AtomicInteger(0);
    private final AtomicInteger createCount = new AtomicInteger(0);
    private final AtomicInteger destroyCount = new AtomicInteger(0);
    private final AtomicInteger invalidCount = new AtomicInteger(0);

    public WcspCryptoServicePlatformPool(WcspEncryptContext context) {
        this.context = context;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(context.getPoolMaxTotal());
        config.setMaxIdle(context.getPoolMaxIdle());
        config.setMinIdle(context.getPoolMinIdle());
        config.setMaxWait(Duration.ofMillis(context.getPoolMaxWaitMillis()));
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        config.setTestWhileIdle(false);
        this.pool = new GenericObjectPool((PooledObjectFactory)new PlatformFactory(), config);
        try {
            this.pool.preparePool();
            log.info("CryptoServicePlatformPool\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u914d\u7f6e: maxTotal={}, minIdle={}, maxIdle={}", new Object[]{config.getMaxTotal(), config.getMinIdle(), config.getMaxIdle()});
        }
        catch (Exception e) {
            log.error("CryptoServicePlatformPool\u9884\u70ed\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("Failed to initialize CryptoServicePlatformPool", e);
        }
    }

    private CryptoServicePlatform initPlatform() {
        String url = this.context.getUrl();
        String tenantId = this.context.getTenantId();
        String appId = this.context.getAppId();
        String secret = this.context.getSecret();
        String workDir = this.context.getWorkDir();
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("url", url);
        params.put("workdir", workDir);
        try {
            CryptoServicePlatform platform = CryptoServicePlatform.getInstance();
            platform.init(tenantId, appId, params);
            platform.authorize((AuthParameterSpec)new AuthSecretParameterSpec.Builder().setSecret(secret).build());
            return platform;
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316CryptoServicePlatform\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("Failed to initialize CryptoServicePlatform", e);
        }
    }

    public CryptoServicePlatform borrowObject() throws Exception {
        try {
            CryptoServicePlatform platform = (CryptoServicePlatform)this.pool.borrowObject();
            this.borrowCount.incrementAndGet();
            return platform;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6CryptoServicePlatform\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    public void returnObject(CryptoServicePlatform platform, boolean isHealthy) {
        if (Objects.isNull(platform)) {
            return;
        }
        if (isHealthy) {
            this.pool.returnObject((Object)platform);
        } else {
            try {
                this.invalidCount.incrementAndGet();
                log.warn("\u9500\u6bc1\u4e0d\u5065\u5eb7\u7684CryptoServicePlatform\u5bf9\u8c61\uff0c\u7d2f\u8ba1\u9500\u6bc1\u6570: {}", (Object)this.invalidCount.get());
                this.pool.invalidateObject((Object)platform);
            }
            catch (Exception e) {
                this.forceDestroy(platform);
            }
        }
    }

    private void forceDestroy(CryptoServicePlatform platform) {
        if (Objects.isNull(platform)) {
            return;
        }
        try {
            platform.finalize();
            log.trace("\u5f3a\u5236\u8c03\u7528CryptoServicePlatform\u7684finalize()\u65b9\u6cd5\u9500\u6bc1\u5bf9\u8c61");
        }
        catch (Exception e) {
            log.error("\u5f3a\u5236\u8c03\u7528CryptoServicePlatform\u7684finalize()\u65b9\u6cd5\u9500\u6bc1\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
        }
    }

    public void close() {
        log.info("\u5173\u95edCryptoServicePlatformPool\uff0c\u7edf\u8ba1: \u521b\u5efa={}, \u501f\u51fa={}, \u9500\u6bc1={}, \u4e0d\u5065\u5eb7\u9500\u6bc1={}", new Object[]{this.createCount.get(), this.borrowCount.get(), this.destroyCount.get(), this.invalidCount.get()});
        this.pool.close();
    }

    public int getActiveCount() {
        return this.pool.getNumActive();
    }

    public int getIdleCount() {
        return this.pool.getNumIdle();
    }

    public int getInvalidCount() {
        return this.invalidCount.get();
    }

    public int getBorrowCount() {
        return this.borrowCount.get();
    }

    @Generated
    public WcspEncryptContext getContext() {
        return this.context;
    }

    private class PlatformFactory
    extends BasePooledObjectFactory<CryptoServicePlatform> {
        private PlatformFactory() {
        }

        public CryptoServicePlatform create() {
            CryptoServicePlatform platform = WcspCryptoServicePlatformPool.this.initPlatform();
            WcspCryptoServicePlatformPool.this.createCount.incrementAndGet();
            return platform;
        }

        public PooledObject<CryptoServicePlatform> wrap(CryptoServicePlatform obj) {
            return new DefaultPooledObject((Object)obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(PooledObject<CryptoServicePlatform> p, DestroyMode destroyMode) {
            try {
                CryptoServicePlatform platform = (CryptoServicePlatform)p.getObject();
                if (Objects.nonNull(platform)) {
                    platform.finalize();
                    log.trace("\u6210\u529f\u8c03\u7528CryptoServicePlatform\u7684finalize()\u65b9\u6cd5\u9500\u6bc1\u5bf9\u8c61");
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528CryptoServicePlatform\u7684finalize()\u65b9\u6cd5\u9500\u6bc1\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            }
            finally {
                WcspCryptoServicePlatformPool.this.destroyCount.incrementAndGet();
            }
        }
    }
}

