package cn.smarthse.framework.sms;

/**
 *
 * 《短信服务接口定义》
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/7/28 17:06
 */
public interface ISMSProviderService {

	/**
	 * 发送短信验证码
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年1月4日-上午9:18:27
	 * @param vcode			短信验证码
	 * @param mobile		接收手机号码
	 * @return
	 */
	boolean sendVcode(String vcode, String mobile);
	
	/**
	 * 通用接口发文本短信
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年1月4日-上午9:27:10
	 * @param text			文本内容
	 * @param mobile		手机号码 
	 * @return
	 */
	String sendTextSms(String text, String mobile);
	
	
	/**
	 * 群发文本短信
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年1月4日-上午9:27:57
	 * @param text				文本内容
	 * @param mobiles			手机号码（多个，按逗号隔开）
	 * @return 1成功
	 */
	String batchSendTextSms(String text, String mobiles);

	
}
