/**
 *
 */
package cn.smarthse.framework.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 *
 * 短信配置属性
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/7/28 15:34
 */
@ConfigurationProperties("smt")
public @Data
class SmtProperties {

    //SMT 通道尝试发送3次,3次之后切换为另一个配置项
    private int trytime = 3;

    //SMT账号
    private String CORPID;
    //SMT密码
    private String PWD;

    private String ENCODING = "UTF-8";
    //统一签名
    private String MSGSIGN = "【智慧职安环保科技】";
    //通用发送接口的http地址
    private String URI_SEND_SMS;
    //群发短信 BatchSend
    private String URI_BATCHSEND_SMS;

    //阿里云短信配置
    private final Dysmsapi dysmsapi = new Dysmsapi();


    public @Data
    static class Dysmsapi {
        //产品名称:云通信短信API产品,开发者无需替换
        private String product = "Dysmsapi";
        //产品域名,开发者无需替换
        private String domain = "dysmsapi.aliyuncs.com";
        // 此处需要替换成开发者自己的AK(在阿里云访问控制台寻找)
        private String regionid = "cn-hangzhou";
        private String endpointname = "cn-hangzhou";
        private String accesskeyid = "";
        private String accesskeysecret = "";
        private String signname = "智慧职安环保科技";
        private String templatecode = "";
    }

}
