package cn.smarthse.framework.bootstrap;

import cn.smarthse.framework.bootstrap.properties.SmtProperties;
import cn.smarthse.framework.sms.ISMSProviderService;
import cn.smarthse.framework.sms.SmsProvideServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 *
 * 短信服务自动配置
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/7/28 15:32
 */
@SpringBootConfiguration
@EnableConfigurationProperties({SmtProperties.class})

@Slf4j
public class SmsAutoConfiguration {

    @Bean
    public ISMSProviderService ISMSProviderService(SmtProperties properties) {

        log.info("配置 短信服务");

        return new SmsProvideServiceImpl(properties);
    }
}
