package cn.smarthse.framework.sms;

import cn.smarthse.framework.bootstrap.properties.SmtProperties;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

/**
 *
 * 《短信服务接口实现类》
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/7/28 17:06
 */
@Slf4j
@RequiredArgsConstructor
public class SmsProvideServiceImpl implements ISMSProviderService {

	private final SmtProperties smtProperties;
	
	@Override
	public boolean sendVcode(String vcode, String mobile) {

		String text = "您的验证码是:" + vcode + ",请勿向任何人泄露,5分钟有效。";

		//验证手机号
		if(!StringUtils.checkMobile(mobile)) {
			log.error("mobile:{}, 发送验证码短信: {} 失败", mobile, text);
			return false;
		}
				
    	log.debug("发送验证码短信: {}", text);
    	int tryCount = 0;
    	String result = null;
        //遍历次数进行重试发送
    	while(tryCount < smtProperties.getTrytime()) {
    		result = batchSendTextSms(text, mobile) ;
    		log.debug("发送验证码短信 result:{}", result);
    		if(StringUtils.isNotEmpty(result)) {
    			break;
    		}
    		tryCount++;
    	}

		//若结果为正常,则结束短信发送线程
    	if(StringUtils.isNotEmpty(result)) {
			return true;
		}
    	
//            	RequestId	String	8906582E-6722	请求ID
//            	Code	String	OK	状态码-返回OK代表请求成功,其他错误码详见错误码列表
//            	Message	String	请求成功	状态码的描述
//            	BizId	String	134523^4351232	发送回执ID,可根据该ID查询具体的发送状态
    	//切换为另一个备用通道发送短信
    	tryCount = 0;
    	SendSmsResponse response;
    	try {
    		while(tryCount < smtProperties.getTrytime()) {
    			response = sendAliVcode(mobile, vcode);
    			if("OK".equals(response.getCode())) {
    				break;
    			}
    			//
    			tryCount++;
    		}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return true;
	}

	@Override
	public String sendTextSms(String text, String mobile) {
		
		log.info("发送文本短信:{}, 短信内容 :{}", mobile, text+ smtProperties.getMSGSIGN());
		
		Map<String, String> params = new HashMap<>();
        params.put("CorpID", smtProperties.getCORPID());
        params.put("Pwd", smtProperties.getPWD());
        params.put("Content", text + smtProperties.getMSGSIGN());
        params.put("Mobile", mobile);
        params.put("Cell", "");
        params.put("SendTime", "");

        return post(smtProperties.getURI_SEND_SMS(), params);
	}

	@Override
	public String batchSendTextSms(String text, String mobiles) {

		Map<String, String> params = new HashMap<>();
        params.put("CorpID", smtProperties.getCORPID());
        params.put("Pwd", smtProperties.getPWD());
        params.put("Content", text + smtProperties.getMSGSIGN());
        params.put("Mobile", mobiles);
        params.put("Cell", "");
        params.put("SendTime", "");
        String result = post(smtProperties.getURI_BATCHSEND_SMS(), params);

		log.info("批量发送文本短信:{}, 短信内容 :{},发送结果:{}", mobiles, text+ smtProperties.getMSGSIGN(), result);

        return result;
	}
	
	
	/**
	 * 通过阿里短信接口发送短信信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月20日-上午11:06:41
	 * @param phoneNumbers	短信接收号码,支持以逗号分隔的形式进行批量调用，批量上限为1000个手机号码,批量调用相对于单条调用及时性稍有延迟,验证码类型的短信推荐使用单条调用的方式；发送国际/港澳台消息时，接收号码格式为00+国际区号+号码，如“0085200000000”
	 * @param vcode			短信验证码
	 * @return
	 * 	<li>OK	请求成功
		<li>isp.RAM_PERMISSION_DENY	RAM权限DENY
		<li>isv.OUT_OF_SERVICE	业务停机
		<li>isv.PRODUCT_UN_SUBSCRIPT	未开通云通信产品的阿里云客户
		<li>isv.PRODUCT_UNSUBSCRIBE	产品未开通
		<li>isv.ACCOUNT_NOT_EXISTS	账户不存在
		<li>isv.ACCOUNT_ABNORMAL	账户异常
		<li>isv.SMS_TEMPLATE_ILLEGAL	短信模板不合法
		<li>isv.SMS_SIGNATURE_ILLEGAL	短信签名不合法
		<li>isv.INVALID_PARAMETERS	参数异常
		<li>isp.SYSTEM_ERROR	系统错误
		<li>isv.MOBILE_NUMBER_ILLEGAL	非法手机号
		<li>isv.MOBILE_COUNT_OVER_LIMIT	手机号码数量超过限制
		<li>isv.TEMPLATE_MISSING_PARAMETERS	模板缺少变量
		<li>isv.BUSINESS_LIMIT_CONTROL	业务限流
		<li>isv.INVALID_JSON_PARAM	JSON参数不合法，只接受字符串值
		<li>isv.BLACK_KEY_CONTROL_LIMIT	黑名单管控
		<li>isv.PARAM_LENGTH_LIMIT	参数超出长度限制
		<li>isv.PARAM_NOT_SUPPORT_URL	不支持URL
		<li>isv.AMOUNT_NOT_ENOUGH	账户余额不足
	 */
	private SendSmsResponse sendAliVcode(String phoneNumbers, String vcode) throws ClientException {
		//您的验证码是:${code},请勿向任何人泄露,5分钟有效。
		Map<String, String> resultMap = new HashMap<>();
		resultMap.put("code", vcode);
		String templateParam = JSONObject.toJSONString(resultMap);
		
		return sendAliSms(phoneNumbers, 
				smtProperties.getDysmsapi().getTemplatecode(), 
				templateParam, null);
	}
	
	/**
	 * 通用阿里云短信接口发送短信信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月19日-下午9:09:21
	 * @param phoneNumbers    短信接收号码,支持以逗号分隔的形式进行批量调用，批量上限为1000个手机号码,批量调用相对于单条调用及时性稍有延迟,验证码类型的短信推荐使用单条调用的方式；发送国际/港澳台消息时，接收号码格式为00+国际区号+号码，如“0085200000000”
	 * @param templateCode    短信模板ID
	 * @param templateParam    短信模板变量替换JSON串,友情提示:如果JSON中需要带换行符,请参照标准的JSON协议。@exapmle {“code”:”1234”,”product”:”ytx”}
	 * @param outId            外部流水扩展字段
	 * @return
	 * @throws ClientException
	 */
	private SendSmsResponse sendAliSms(String phoneNumbers, String templateCode, String templateParam, String outId) throws ClientException {
		
        //可自助调整超时时间
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");

        //初始化acsClient,暂不支持region化
        IClientProfile profile = DefaultProfile.getProfile(
        		smtProperties.getDysmsapi().getRegionid(), 
        		smtProperties.getDysmsapi().getAccesskeyid(), 
        		smtProperties.getDysmsapi().getAccesskeysecret()
        		);
        DefaultProfile.addEndpoint(
        		smtProperties.getDysmsapi().getEndpointname(),
        		smtProperties.getDysmsapi().getRegionid(),
        		smtProperties.getDysmsapi().getProduct(),
        		smtProperties.getDysmsapi().getDomain());
        IAcsClient acsClient = new DefaultAcsClient(profile);

        //组装请求对象-具体描述见控制台-文档部分内容
        SendSmsRequest request = new SendSmsRequest();
        //必填:待发送手机号
        request.setPhoneNumbers(phoneNumbers);
        //必填:短信签名-可在短信控制台中找到
        request.setSignName(smtProperties.getDysmsapi().getSignname());
        //必填:短信模板-可在短信控制台中找到
        request.setTemplateCode(templateCode);
        //可选:模板中的变量替换JSON串,如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为
        if(StringUtils.isNotEmpty(templateParam)) {
        	 request.setTemplateParam(templateParam);
        }
       
		//可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
        if(StringUtils.isNotEmpty(outId)) {
        	 request.setOutId(outId);
        }
		request.setVersion("2017-05-25");
       
        //hint 此处可能会抛出异常，注意catch
		return acsClient.getAcsResponse(request);
    }
	
	/**
     * 基于HttpClient 4.3的通用POST方法
     *
     * @param url       提交的URL
     * @param paramsMap 提交<参数，值>Map
     * @return 提交响应
     */
    private String post(String url, Map<String, String> paramsMap) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpPost method = new HttpPost(url);
            if (paramsMap != null) {
                List<NameValuePair> paramList = new ArrayList<>();
                for (Map.Entry<String, String> param : paramsMap.entrySet()) {
                    NameValuePair pair = new BasicNameValuePair(param.getKey(), param.getValue());
                    paramList.add(pair);
                }
                method.setEntity(new UrlEncodedFormEntity(paramList, smtProperties.getENCODING()));
            }
            response = client.execute(method);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseText = EntityUtils.toString(entity);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
				assert response != null;
				response.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }


}
