/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.redis;

import java.time.Duration;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.util.StringUtils;

public class TtlRedisCacheManager
extends RedisCacheManager {
    public TtlRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration);
    }

    protected RedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
        String[] cells = StringUtils.delimitedListToStringArray((String)name, (String)"=");
        name = cells[0].trim();
        if (cells.length > 1) {
            long ttl = Long.parseLong(cells[1].trim());
            cacheConfig = cacheConfig.entryTtl(Duration.ofHours(ttl));
        }
        return super.createRedisCache(name, cacheConfig);
    }
}

