package cn.smarthse.framework.redis;

import java.time.Duration;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.util.StringUtils;

/**
 *
 * 自定义CacheManager, 解析 @Cacheable 支持设置缓存有效时间，写法如下:
 *      <code>@Cacheable(value = "AdminHome=24", key = "#root.methodName")</code> 代表缓存有效期24h
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/9/13 15:36
 */
public class TtlRedisCacheManager extends RedisCacheManager {

    public TtlRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration);
    }

    @Override
    protected RedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
        String[] cells = StringUtils.delimitedListToStringArray(name, "=");
        name = cells[0].trim();
        if (cells.length > 1) {
            long ttl = Long.parseLong(cells[1].trim());
            // 根据传参设置缓存失效时间
            cacheConfig = cacheConfig.entryTtl(Duration.ofHours(ttl));
        }
        return super.createRedisCache(name, cacheConfig);
    }
}
