package cn.smarthse.invoice.model;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

@Data
public class QueryInvoiceResultParam implements Serializable {

    private static final long serialVersionUID = -6466441046352340913L;

    @ApiModelProperty(value = "发票流水号，两字段二选一，同时存在以流水号为准")
    private String[] serialNos;

    @ApiModelProperty(value = "订单编号")
    private String[] orderNos;

    @ApiModelProperty(value = "是1否0需要提供明细(不填默认false)")
    private String isOfferInvoiceDetail;

    public QueryInvoiceResultParam() {
    }

    public QueryInvoiceResultParam(String[] serialNos, String[] orderNos, String isOfferInvoiceDetail) {
        this.serialNos = serialNos;
        this.orderNos = orderNos;
        this.isOfferInvoiceDetail = isOfferInvoiceDetail;
    }
}
