package cn.smarthse.invoice.model;

import java.io.Serializable;
import lombok.Data;

@Data
public class InvoiceKpResultDetailModel implements Serializable {
    
	private static final long serialVersionUID = -6466441046352340913L;

	//发票请求流水号
    private String serialNo;

    //订单编号
    private String orderNo;

    //发票代码
    private String invoiceCode;

    //发票号码
    private String invoiceNo;

    /* 发票状态： 2 :开票完成（最终状态），其他状态分别为:20:开票中;21:开票成功签章中;22:开票失败;24: 开票成功签章失败;3:发票已作废 31: 发票作废中
                备注：22、24状态时，无需再查询，请确认开票失败原因以及签章失败原因；3、31只针对纸票 注：请以该状态码区分发票状态*/
    private String status;

    //发票状态描述
    private String statusMsg;

    //失败原因
    private String failCause;

    //发票pdf地址（若同时返回了ofdUrl与pdfUrl，则pdf文件不能做为原始凭证，请用ofd文件做为原始凭证）
    private String pdfUrl;

    //发票图片地址
    private String pictureUrl;

    //发票ofd地址（公共服务平台签章时返回）
    private String ofdUrl;

    //购方名称（付款方名称）
    private String payerName;

    //购方税号（付款方税号）
    private String payerTaxNo;

    //购方手机(开票成功会短信提醒购方)
    private String phone;

    //购方邮箱推送邮箱(开票成功会邮件提醒购方)
    private String notifyEmail;


}
