package cn.smarthse.invoice.model;


import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Data;

@Data
public class InvoiceKpParam implements Serializable {
    
	private static final long serialVersionUID = -6466441046352340913L;

    @ApiModelProperty(value = "购方名称(企业或个人)",required = true)
    private String buyerName;

    @ApiModelProperty(value = "购方企业税号(企业要填，个人可为空)")
    private String buyerTaxNum;

    @ApiModelProperty(value = "购方电话")
    private String buyerTel;

    @ApiModelProperty(value = "购方地址")
    private String buyerAddress;

    @ApiModelProperty(value = "购方企业银行开户行及账号")
    private String buyerAccount;

    @ApiModelProperty(value = "销方企业税号",required = true)
    private String salerTaxNum;

    @ApiModelProperty(value = "销方企业电话",required = true)
    private String salerTel;

    @ApiModelProperty(value = "销方地址",required = true)
    private String salerAddress;

    @ApiModelProperty(value = "销方企业银行开户行及账号")
    private String salerAccount;

    @ApiModelProperty(value = "订单号(每个企业唯一)",required = true)
    private String orderNo;

    @ApiModelProperty(value = "单据时间")
    private String invoiceDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());

    @ApiModelProperty(value = "冲红时填写的对应蓝票发票代码（红票必填）")
    private String invoiceCode;

    @ApiModelProperty(value = "冲红时填写的对应蓝票发票号码（红票必填，不满8位请左补0）")
    private String invoiceNum;

    @ApiModelProperty(value = "开票员",required = true)
    private String clerk = "钱小阳";

    @ApiModelProperty(value = "收款人")
    private String payee = "谢秀楠";

    @ApiModelProperty(value = "复核人")
    private String checker = "谢秀楠";

    @ApiModelProperty(value = "推送方式：-1,不推送;0,邮箱;1,手机（默认）;2,邮箱、手机")
    private String pushMode = "0";

    @ApiModelProperty(value = "购方手机（pushMode为1或2时，此项为必填）",required = true)
    private String buyerPhone;

    @ApiModelProperty(value = "推送邮箱（pushMode为0或2时，此项为必填）",required = true)
    private String email;

    @ApiModelProperty(value = "发票类型，1:正票;2：红票",required = true)
    private String invoiceType = "1";

    @ApiModelProperty(value = "开票完成回传发票信息地址")
    private String callBackUrl;

    @ApiModelProperty(value = "发票明细",required = true)
    List<InvoiceGoodsDetailModel> invoiceDetail = new ArrayList<>();

}
