/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.content.bean;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SpringContextHolder.class);
    private static ApplicationContext applicationContext = null;

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return applicationContext;
    }

    public static void setApplicationContextTest(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public static void setAnnotationConfigApplicationContext(AnnotationConfigApplicationContext annotationConfigApplicationContext) {
        logger.info("\u914d\u7f6e AnnotationConfigApplicationContext \u5230 SpringContextHolder");
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    public static void clearHolder() {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext);
        }
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.debug("\u6ce8\u5165ApplicationContext\u5230SpringContextHolder:{}", (Object)applicationContext);
        if (SpringContextHolder.applicationContext != null) {
            logger.info("SpringContextHolder\u4e2d\u7684ApplicationContext\u88ab\u8986\u76d6, \u539f\u6709ApplicationContext\u4e3a:" + SpringContextHolder.applicationContext);
        }
        SpringContextHolder.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        SpringContextHolder.clearHolder();
    }

    private static void assertContextInjected() {
    }
}

