package cn.smarthse.framework.content.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 任务调度配置 taskExecutor
 * <li>核心线程数    <  任务队列        <  最大线程数</li>
 * <li>corePoolSize <  queueCapacity  <  maxPoolSize</li>
 * @Author liaoly
 * @Date 2020年9月1日 上午8:16:27
 */
@ConfigurationProperties("taskexecutor")
public @Data class TaskExecutorProperties {

    /**
     * 指定用于新创建的线程名的前缀。默认为“SimpleAsyncTaskExecutor-”
     */
    private String threadNamePrefix;
    /**
     * 核心线程数，核心线程会一直存活，即使没有任务 cpu核数*2+1
     */
    private int corePoolSize;
    /**
     * 阻塞队列的容量，用来存储等待执行的任务
     */
    private int queueCapacity;
    /**
     * 线程池中的最大线程数
     */
    private int maxPoolSize;
    /**
     * 线程空闲时间/s
     */
    private int keepAliveSeconds;
}
