/**
 * 
 */
package cn.smarthse.framework.content.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 *
 *  aliyun oss 配置
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/9 16:34
 */
@ConfigurationProperties(prefix = "ossclient")
public @Data class OssClientProperties {

	/** 文件本地根路径 eg：D:\\data\*/
	private String local;
	/**eg：oss-cn-hangzhou.aliyuncs.com*/
	private String domain;
	/**eg：https://oss-cn-hangzhou.aliyuncs.com*/
	private String endpoint;
	private String accesskey;
	private String accesssecret;
	/**
	 * 是否同步到OSS,true时自动同步到阿里云OSS服务器
	 */
	private boolean asynch = true;
	/**
	 * eg: yanfa-oss-file1
	 */
	private String bucketname;
	/**
	 * 是否公用读：=true时，getUrl不需要生成访问密钥串
	 */
	private boolean publicread;
	/**
	 * 非公用读：=false时，OSSAccessKeyId有效期，默认 7200/s
	 */
	private int exptime = 7200;
}
