/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.content.bootstrap;

import cn.smarthse.framework.content.bean.OssClientBean;
import cn.smarthse.framework.content.bean.SpringContextHolder;
import cn.smarthse.framework.content.bootstrap.properties.OssClientProperties;
import cn.smarthse.framework.content.bootstrap.properties.TaskExecutorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={OssClientProperties.class, TaskExecutorProperties.class})
public class ContentConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ContentConfiguration.class);
    private final OssClientProperties ossClientProperties;
    private final TaskExecutorProperties taskExecutorProperties;

    @Bean(name={"ossClient"})
    @ConditionalOnProperty(prefix="ossclient", name={"domain"})
    public OssClientBean getOssClientBean() {
        log.info("\u914d\u7f6eOssClientBean {}", (Object)this.ossClientProperties.getBucketname());
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setLocal(this.ossClientProperties.getLocal());
        ossClientBean.setDomain(this.ossClientProperties.getDomain());
        ossClientBean.setEndpoint(this.ossClientProperties.getEndpoint());
        ossClientBean.setAccessKeyId(this.ossClientProperties.getAccesskey());
        ossClientBean.setAccessKeySecret(this.ossClientProperties.getAccesssecret());
        ossClientBean.setBucketName(this.ossClientProperties.getBucketname());
        ossClientBean.setAsynch(this.ossClientProperties.isAsynch());
        ossClientBean.setPublicread(this.ossClientProperties.isPublicread());
        ossClientBean.setExptime(this.ossClientProperties.getExptime());
        return ossClientBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="taskexecutor", name={"thread_name_prefix"})
    public ThreadPoolTaskExecutor taskExecutor() {
        log.info("\u914d\u7f6eThreadPoolTaskExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(this.taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(this.taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(this.taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(this.taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(this.taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> log.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u65e0\u6cd5\u6267\u884c\u65b0\u4efb\u52a1\uff0c\u4efb\u52a1\u4e22\u5f03"));
        executor.initialize();
        return executor;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    public ContentConfiguration(OssClientProperties ossClientProperties, TaskExecutorProperties taskExecutorProperties) {
        this.ossClientProperties = ossClientProperties;
        this.taskExecutorProperties = taskExecutorProperties;
    }
}

