package cn.smarthse.framework.content.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 任务调度配置 taskExecutor
 * 
 * @Author liaoly
 * @Date 2020年9月1日 上午8:16:27
 */
@ConfigurationProperties("taskexecutor")
public @Data class TaskExecutorProperties {
	
	private String threadNamePrefix;
	/**
	 * 核心线程数，核心线程会一直存活，即使没有任务 cpu核数*2+1
	 */
    private int core_pool_size;
    /**
     * 线程池中的最大线程数
     */
    private int max_pool_size;
    /**
     * 阻塞队列的容量，用来存储等待执行的任务
     */
    private int queue_capacity;
    /**
     * 线程空闲时间/s
     */
    private int keep_alive_seconds;
}
