package cn.smarthse.framework.content.bootstrap;

import cn.smarthse.framework.content.bean.OssClientBean;
import cn.smarthse.framework.content.bean.SpringContextHolder;
import cn.smarthse.framework.content.bootstrap.properties.OssClientProperties;
import cn.smarthse.framework.content.bootstrap.properties.TaskExecutorProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/**
 *
 * 普通内容配置器
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/9 16:36
 */
@Configuration
@EnableConfigurationProperties({OssClientProperties.class, TaskExecutorProperties.class})
@RequiredArgsConstructor
@Slf4j
public class ContentConfiguration {

	private final OssClientProperties ossClientProperties;

	private final TaskExecutorProperties taskExecutorProperties;

	@Bean(name="ossClient")
	@ConditionalOnProperty(prefix = "ossclient", name = "domain")
	public OssClientBean getOssClientBean() {

		log.info("配置OssClientBean {}", ossClientProperties.getOss_bucketname());

		OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setLocal(ossClientProperties.getOss_local());
		ossClientBean.setDomain(ossClientProperties.getDomain());
		ossClientBean.setEndpoint(ossClientProperties.getOss_endpoint());
		ossClientBean.setAccessKeyId(ossClientProperties.getOss_accesskey());
		ossClientBean.setAccessKeySecret(ossClientProperties.getOss_accesssecret());
		ossClientBean.setBucketName(ossClientProperties.getOss_bucketname());
		ossClientBean.setAsynch(ossClientProperties.isOss_asynch());
		ossClientBean.setPublicread(ossClientProperties.isPublicread());
		ossClientBean.setExptime(ossClientProperties.getExptime());
		return ossClientBean;
	}

	/**
	 *
	 * 自定义线程池
	 *
	 * @author liaoly
	 * @date 2021年9月8日 上午10:47:42
	 * @return AsyncTaskExecutor
	 */
	@Bean
	@ConditionalOnProperty(prefix = "taskexecutor", name = "thread_name_prefix")
	public ThreadPoolTaskExecutor taskExecutor() {

		log.info("配置ThreadPoolTaskExecutor");

		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();

		//线程池中的线程的名称前缀
		executor.setThreadNamePrefix(taskExecutorProperties.getThreadNamePrefix());
		//核心线程数
		executor.setCorePoolSize(taskExecutorProperties.getCore_pool_size());
		//最大线程数
		executor.setMaxPoolSize(taskExecutorProperties.getMax_pool_size());
		//队列大小
		executor.setQueueCapacity(taskExecutorProperties.getQueue_capacity());
		//线程活跃时间（秒）
		executor.setKeepAliveSeconds(taskExecutorProperties.getKeep_alive_seconds());

		// 设置拒绝策略
		executor.setRejectedExecutionHandler((r, executor1) -> log.error("线程池已满，无法执行新任务，任务丢弃"));
		// 使用预定义的异常处理类
		// executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		executor.initialize();
		return executor;
	}

	@Bean
	public SpringContextHolder springContextHolder() {
		return new SpringContextHolder();
	}
}
