package cn.smarthse.invoice.service;

import cn.smarthse.invoice.model.InValidInvoiceParam;
import cn.smarthse.invoice.model.InvoiceKpDetailModel;
import cn.smarthse.invoice.model.QueryInvoiceResultParam;

/**
 * @ClassName InvoiceSDKService
 * @Description 在线发票请求接口---sdk调用
 * @Author Wuxq
 * @Date 2021/7/5
 */

public interface InvoiceService {

    /**
     * 方法描述: 开票请求接口
     *
     * @param order 请求参数对象
     * @return String invoiceSerialNum: 提交成功则返回发票请求流水号
     * @author wuxq
     * @date 2021/7/1
     */
    String requestBillingNew(InvoiceKpDetailModel order);

    /**
     * 方法描述:  开票结果查询接口
     *
     * @param serialNumber 开票请求流水号
     * @return String
     * @author wuxq
     * @date 2021/7/1
     */
    String queryInvoiceBySerialNumber(QueryInvoiceResultParam queryParam);

    /**
     * 方法描述:  发票作废接口(当月开具有误的发票可作废，当月之前的只能开红票，也就是冲红，来抵消之前的误开票据)
     *
     * @param serialNumber 开票请求流水号
     * @return String
     * @author wuxq
     * @date 2021/7/1
     */
    String invoiceCancellation(InValidInvoiceParam queryParam);
}
