package cn.smarthse.invoice.model;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Description  发票请求明细
 * @Author Wuxq
 * @Date 10:18 2021/3/2
 **/
@Data
public class InvoiceKpDetailModel implements Serializable {
    
	private static final long serialVersionUID = -6466441046352340913L;

    @ApiModelProperty(value = "购方名称(企业或个人)",required = true)
    private String buyerName;

    @ApiModelProperty(value = "购方企业税号(企业要填，个人可为空)")
    private String buyerTaxNum;

    @ApiModelProperty(value = "购方电话")
    private String buyerTel;

    @ApiModelProperty(value = "购方地址")
    private String buyerAddress;

    @ApiModelProperty(value = "购方企业银行开户行及账号")
    private String buyerAccount;

    @ApiModelProperty(value = "销方企业税号",required = true)
    private String salerTaxNum;

    @ApiModelProperty(value = "销方企业电话",required = true)
    private String salerTel;

    @ApiModelProperty(value = "销方地址",required = true)
    private String salerAddress;

    @ApiModelProperty(value = "销方企业银行开户行及账号")
    private String salerAccount;

    @ApiModelProperty(value = "订单号(每个企业唯一)",required = true)
    private String orderNo;

    @ApiModelProperty(value = "单据时间",required = true)
    private String invoiceDate;

    @ApiModelProperty(value = "冲红时填写的对应蓝票发票代码（红票必填）")
    private String invoiceCode;

    @ApiModelProperty(value = "冲红时填写的对应蓝票发票号码（红票必填，不满8位请左补0）")
    private String invoiceNum;

    @ApiModelProperty(value = "红字信息表编号,专票冲红时，此项必填。且必须在备注中注明“开具红字增值税专用发票信息表编号ZZZZZZZZZZZZZZZZ”字样，其中“Z”为开具红字增值税专用发票所需要的长度为16位信息表编号。")
    private String billInfoNo;

    @ApiModelProperty(value = "部门门店id(诺诺网系统中的id)")
    private String departmentId;

    @ApiModelProperty(value = "开票员id(诺诺网系统中的id)")
    private String clerkId;

    @ApiModelProperty(value = "冲红时，在备注中注明“对应正数发票代码:XXXXXXXXX号码:YYYYYYYY”文案，其中“X”为发票代码，“Y”为发票号码，可以不填，接口会自动添加该文案；")
    private String remark;

    @ApiModelProperty(value = "开票员",required = true)
    private String clerk;

    @ApiModelProperty(value = "收款人")
    private String payee;

    @ApiModelProperty(value = "复核人")
    private String checker;

    @ApiModelProperty(value = "清单标志：非清单:0；清单:1，默认:0")
    private String listFlag = "0";

    @ApiModelProperty(value = "清单项目名称：对应发票票面项目名称（listFlag为1时，必填，默认为“详见销货清单")
    private String listName = "详见销货清单";

    @ApiModelProperty(value = "推送方式：-1,不推送;0,邮箱;1,手机（默认）;2,邮箱、手机")
    private String pushMode = "0";

    @ApiModelProperty(value = "购方手机（pushMode为1或2时，此项为必填）",required = true)
    private String buyerPhone;

    @ApiModelProperty(value = "推送邮箱（pushMode为0或2时，此项为必填）",required = true)
    private String email;

    @ApiModelProperty(value = "发票类型，1:正票;2：红票",required = true)
    private String invoiceType;

    @ApiModelProperty(value = "发票种类：p,普通发票(电票)(默认);c,普通名称 类型 是否必须 示例值 最大长度 描述发票(纸票);" +
                                      "s,专用发票;e,收购发票(电票);f,收购发票(纸质);r,普通发票(卷式);b,增值税电子专用发票;j,机动车销售统一发票")
    private String invoiceLine = "p";

    @ApiModelProperty(value = "成品油标志：0(默认)非成品油，1成品油")
    private String productOilFlag = "0";

    @ApiModelProperty(value = "代开标志：0非代开;1代开。代开蓝票时备注要求填写文案：代开企业税号:***,代开企业名称:***；" +
                                "代开红票时备注要求填写文案：对应正数发票代码:***号码:***代开企业税号:***代开企业名称:***")
    private String proxyInvoiceFlag = "0";

    @ApiModelProperty(value = "开票完成回传发票信息地址")
    private String callBackUrl;

    @ApiModelProperty(value = "分机号（只能为空或者数字）")
    private String extensionNumber;

    @ApiModelProperty(value = "终端号（开票终端号，只能 为空或数字）")
    private String terminalNumber;

    @ApiModelProperty(value = "机器编号")
    private String machineCode;

    @ApiModelProperty(value = "是否机动车类专票 0-否(默认) 1-是")
    private String vehicleFlag = "0";

    @ApiModelProperty(value = "发票明细",required = true)
    List<InvoiceGoodsDetailModel> invoiceDetail;

}
